/*
 * Decompiled with CFR 0.152.
 */
package fftexplorer;

import fftexplorer.FFTExplorer;
import java.io.ByteArrayOutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class AudioCapture {
    boolean capture = false;
    boolean suspend = false;
    ByteArrayOutputStream byteArrayOutputStream;
    AudioFormat audioFormat;
    TargetDataLine targetDataLine;
    AudioInputStream audioInputStream;
    SourceDataLine sourceDataLine;
    FFTExplorer parent;
    Thread captureThread = null;
    byte[] captureBuffer;
    double sampleRate = 44100.0;

    public AudioCapture(FFTExplorer p) {
        this.parent = p;
    }

    public void startCapture() {
        try {
            this.stopCapture();
            this.sampleRate = this.getSampleRate();
            this.parent.sv_sampleRateTextField.setText(this.parent.formatNum(this.sampleRate));
            this.parent.signalProcessor.initialize(false);
            this.captureBuffer = new byte[this.parent.arraySize * 2];
            this.audioFormat = this.getAudioFormat();
            this.capture = true;
            this.parent.setSampleRate();
            DataLine.Info dataLineInfo = new DataLine.Info(TargetDataLine.class, this.audioFormat);
            this.targetDataLine = (TargetDataLine)AudioSystem.getLine(dataLineInfo);
            this.targetDataLine.open(this.audioFormat);
            this.targetDataLine.start();
            this.captureThread = new Thread(new AudioCaptureThread());
            this.captureThread.start();
        }
        catch (Exception e2) {
            System.out.println("capture: " + e2);
            this.parent.beep();
            this.targetDataLine = null;
        }
        this.parent.setAudioSampleColor(this.targetDataLine != null);
    }

    public boolean capturing() {
        return this.capture;
    }

    public double getSampleRate() {
        return this.parent.getDouble(this.parent.sv_audioDataRateComboBoxIndex, this.sampleRate);
    }

    public void suspend(boolean susp) {
        if (susp && this.capture && this.sampleRate != this.getSampleRate()) {
            this.stopCapture();
            this.sampleRate = this.getSampleRate();
            this.startCapture();
        }
        this.suspend = susp;
    }

    public void stopCapture() {
        this.capture = false;
        if (this.captureThread != null) {
            try {
                this.captureThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.captureThread = null;
        this.parent.signalProcessor.stopSynthesis();
        this.parent.setAudioSampleColor(true);
    }

    private AudioFormat getAudioFormat() {
        this.sampleRate = this.parent.getDouble(this.parent.sv_audioDataRateComboBoxIndex, this.sampleRate);
        int sampleSizeInBits = 16;
        int channels = 1;
        boolean signed = true;
        boolean bigEndian = false;
        return new AudioFormat((float)this.sampleRate, sampleSizeInBits, channels, signed, bigEndian);
    }

    class AudioCaptureThread
    extends Thread {
        AudioCaptureThread() {
        }

        public void run() {
            AudioCapture.this.byteArrayOutputStream = new ByteArrayOutputStream();
            AudioCapture.this.capture = true;
            AudioCapture.this.suspend = false;
            try {
                while (AudioCapture.this.capture) {
                    if (AudioCapture.this.suspend) {
                        Thread.sleep(250L);
                        continue;
                    }
                    int cnt = AudioCapture.this.targetDataLine.read(AudioCapture.this.captureBuffer, 0, AudioCapture.this.captureBuffer.length);
                    if (cnt <= 0) continue;
                    AudioCapture.this.byteArrayOutputStream.write(AudioCapture.this.captureBuffer, 0, cnt);
                    AudioCapture.this.parent.signalProcessor.readAudio(AudioCapture.this.byteArrayOutputStream);
                }
                AudioCapture.this.byteArrayOutputStream.close();
                AudioCapture.this.targetDataLine.close();
            }
            catch (Exception e2) {
                System.out.println("CaptureThread: " + e2);
            }
        }
    }
}

