/*
 * Decompiled with CFR 0.152.
 */
package fftexplorer;

import fftexplorer.GraphicControl;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComboBox;

public final class ComboControl {
    JComboBox box;
    GraphicControl parent;
    String tip = "Spin mouse wheel to change";

    public ComboControl(GraphicControl p, JComboBox box) {
        this.parent = p;
        this.box = box;
        box.setToolTipText(this.tip);
        box.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent evt) {
                ComboControl.this.handleMouseWheelMoved(evt);
            }
        });
    }

    void handleMouseWheelMoved(MouseWheelEvent evt) {
        int n2 = this.box.getSelectedIndex();
        int top = this.box.getItemCount();
        int delta = evt.getWheelRotation();
        n2 -= delta;
        n2 = Math.max(0, n2);
        n2 = Math.min(n2, top - 1);
        this.box.setSelectedIndex(n2);
        this.parent.adjustControls();
    }
}

