/*
 * Decompiled with CFR 0.152.
 */
package fftexplorer;

import fftexplorer.AudioCapture;
import fftexplorer.ColorButton;
import fftexplorer.GraphicControl;
import fftexplorer.GraphicPanel;
import fftexplorer.InitManager;
import fftexplorer.MP3Stream;
import fftexplorer.MyHelpPane;
import fftexplorer.SignalProcessor;
import fftexplorer.UserActionManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.html.parser.ParserDelegator;

public final class FFTExplorer
extends JPanel {
    public final String appVersion = "3.9";
    public final String appName;
    final String programName;
    JFrame sv_mainFrame = null;
    final boolean applet;
    public InitManager initManager;
    MyHelpPane helpPane;
    NumberFormat numberFormat;
    public SignalProcessor signalProcessor;
    public GraphicPanel freqDisp;
    public GraphicPanel timeDisp;
    JComboBox sv_timeVertIndex;
    JComboBox sv_freqVertIndex;
    JComboBox sv_timeHorizIndex;
    JComboBox sv_freqHorizIndex;
    GraphicControl freqControl;
    GraphicControl timeControl;
    AudioCapture audioCapture;
    MP3Stream mp3Stream = null;
    String[] audioDataRates = new String[]{"768000", "384000", "192000", "96000", "48000", "44100", "22050", "16000", "11025", "8000", "4000", "2000"};
    boolean running = true;
    Timer graphicTimer = null;
    Thread graphicThread = null;
    int graphicLineWidth = 1;
    boolean sv_graphicTipFlag;
    double av = 0.0;
    protected Rectangle screenBounds = new Rectangle(0, 0, 800, 600);
    int arraySize = 16384;
    double sampleRate = 8192.0;
    double carrier = 100.0;
    double modFreq = 25.0;
    double modLevel = 1.0;
    double noiseLevel = 1.0;
    double sv_xTimeOffset = 0.0;
    double sv_xFreqOffset = 0.0;
    ColorButton sv_backgroundColor;
    ColorButton sv_traceColor;
    String sv_soundSourceDirectory = "";
    protected JScrollBar sv_helpScrollBar = null;
    final String[] timeUnits = new String[]{"s", "ms", "us", "ns", "ps"};
    final String[] freqUnits = new String[]{"Hz", "kHz", "MHz", "GHz", "THz"};
    private JLabel arraySizeLabel;
    private JLabel audioDataRateLabel;
    private JButton backgroundColorButton;
    private JPanel configPanel;
    private JPanel configSubPanel;
    private JButton defaultsButton;
    private JPanel gContentPanel;
    private JPanel gControlPanel;
    private JPanel graphicHolderPanel;
    private JPanel helpPanel;
    private JPanel internalSourcePanel;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel modePanel;
    private JPanel mp3Panel;
    protected JProgressBar mp3StreamProgressBar;
    private JPanel soundCapturePanel;
    private JPanel soundCardPanel;
    private JLabel soundCardSourceLabel;
    private JPanel southPanel;
    private JButton startAudioCaptureButton;
    protected JButton startMP3Button;
    protected JButton startSynthButton;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private JButton stopAudioCaptureButton;
    protected JButton stopMP3Button;
    protected JButton stopSynthButton;
    protected JRadioButton sv_amRadioButton;
    protected JCheckBox sv_antialiasCheckBox;
    protected JComboBox sv_arraySizeComboBoxIndex;
    protected JComboBox sv_audioDataRateComboBoxIndex;
    protected JTextField sv_carrierTextField;
    protected JRadioButton sv_fmRadioButton;
    protected JCheckBox sv_freqDispCheckBox;
    protected JCheckBox sv_horizontalCheckBox;
    protected JComboBox sv_lineWidthComboBox;
    protected JTabbedPane sv_mainTabbedPane;
    protected JTextField sv_modFreqTextField;
    protected JTextField sv_modPercentTextField;
    protected JTextField sv_noiseLevelTextField;
    protected JTextField sv_sampleRateTextField;
    protected JCheckBox sv_soundCheckBox;
    protected JRadioButton sv_sqwRadioButton;
    protected JRadioButton sv_stRadioButton;
    protected JCheckBox sv_timeDispCheckBox;
    protected JRadioButton sv_twRadioButton;
    private ButtonGroup synthModeButtonGroup;
    private JButton traceColorButton;

    public FFTExplorer(Object p, boolean app, String[] args) {
        this.applet = app;
        if (!this.applet) {
            this.sv_mainFrame = (JFrame)p;
        }
        ParserDelegator workaround = new ParserDelegator();
        this.initComponents();
        this.numberFormat = NumberFormat.getInstance();
        this.appName = this.getClass().getSimpleName();
        this.programName = this.appName + " " + "3.9";
        this.audioCapture = new AudioCapture(this);
        this.sv_traceColor = new ColorButton(this, this.traceColorButton, new Color(0, 128, 0), "Line drawing color");
        this.sv_backgroundColor = new ColorButton(this, this.backgroundColorButton, new Color(255, 255, 255), "Graph Background color");
        this.signalProcessor = new SignalProcessor(this);
        this.freqControl = new GraphicControl(this, true);
        this.timeControl = new GraphicControl(this, false);
        this.sv_timeVertIndex = this.timeControl.vertComboBox;
        this.sv_freqVertIndex = this.freqControl.vertComboBox;
        this.sv_timeHorizIndex = this.timeControl.horizComboBox;
        this.sv_freqHorizIndex = this.freqControl.horizComboBox;
        this.setupControls();
        this.resetDefaults(false);
        this.initManager = new InitManager(this, this.applet);
        this.helpPane = new MyHelpPane(this);
        this.addComponent(this.helpPane, this.helpPanel, 0, 0, 1.0, 0.01, 0);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!FFTExplorer.this.applet) {
                    FFTExplorer.this.sv_mainFrame.setBounds(FFTExplorer.this.screenBounds);
                    FFTExplorer.this.initManager.readConfig();
                }
                FFTExplorer.this.readControls();
                FFTExplorer.this.freqControl.graphicPane.setupOffset();
                FFTExplorer.this.timeControl.graphicPane.setupOffset();
                FFTExplorer.this.setupDisplayConfig();
                FFTExplorer.this.handleTabbedPaneChange();
            }
        });
    }

    public void p(String s) {
        System.out.println(s);
    }

    void setStatus(String s) {
        this.statusLabel.setText(s);
    }

    void errorMessage(String s) {
        this.beep();
        JOptionPane.showMessageDialog(this, s, this.programName + " Error", 2);
    }

    void appletError() {
        this.beep();
        this.setStatus("<html><b>Sorry, Web-based applets don't allow this. Consider downloading " + this.programName + ".</b></html>");
    }

    void setupDisplayConfig() {
        this.gContentPanel.removeAll();
        boolean freqSel = this.sv_freqDispCheckBox.isSelected();
        boolean timeSel = this.sv_timeDispCheckBox.isSelected();
        if (!freqSel && !timeSel) {
            this.sv_freqDispCheckBox.setSelected(true);
            freqSel = true;
        }
        boolean horiz = this.sv_horizontalCheckBox.isSelected();
        if (freqSel) {
            if (horiz) {
                this.addComponent(this.freqControl, this.gContentPanel, 1, 0);
            } else {
                this.addComponent(this.freqControl, this.gContentPanel, 0, 1);
            }
        }
        if (timeSel) {
            if (horiz) {
                this.addComponent(this.timeControl, this.gContentPanel, 0, 0);
            } else {
                this.addComponent(this.timeControl, this.gContentPanel, 0, 0);
            }
        }
        this.gContentPanel.validate();
        this.repaint();
    }

    public void addComponent(JPanel source, JComponent target, int x, int y) {
        this.addComponent(source, target, x, y, 1.0, 1.0, 0);
    }

    public void addComponent(JPanel source, JComponent target, int x, int y, double wx, double wy, int insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = x;
        gridBagConstraints.gridy = y;
        gridBagConstraints.insets = new Insets(insets, insets, insets, insets);
        gridBagConstraints.weightx = wx;
        gridBagConstraints.weighty = wy;
        target.add((Component)source, gridBagConstraints);
        target.revalidate();
    }

    void setupControls() {
        int n2;
        new UserActionManager(1.0, 0.0, 1.0E12, this.sv_carrierTextField, this);
        new UserActionManager(1.0, 0.0, 1.0E9, this.sv_modFreqTextField, this);
        new UserActionManager(1.0, 0.0, 1000.0, this.sv_modPercentTextField, this);
        new UserActionManager(1.0, 0.0, 10000.0, this.sv_noiseLevelTextField, this);
        new UserActionManager(1.0, 0.0, 1.0E12, this.sv_sampleRateTextField, this);
        new UserActionManager(this.sv_arraySizeComboBoxIndex, this);
        new UserActionManager(this.sv_audioDataRateComboBoxIndex, this);
        new UserActionManager(this.sv_lineWidthComboBox, this);
        this.sv_arraySizeComboBoxIndex.removeAllItems();
        for (n2 = 4; n2 < 20; ++n2) {
            this.sv_arraySizeComboBoxIndex.addItem("" + (int)Math.pow(2.0, n2));
        }
        this.sv_audioDataRateComboBoxIndex.removeAllItems();
        for (n2 = 0; n2 < this.audioDataRates.length; ++n2) {
            this.sv_audioDataRateComboBoxIndex.addItem(this.audioDataRates[n2]);
        }
        this.sv_lineWidthComboBox.removeAllItems();
        for (n2 = 1; n2 <= 32; ++n2) {
            this.sv_lineWidthComboBox.addItem("" + n2);
        }
    }

    public void readControls(boolean sampleRateEntry) {
        this.signalProcessor.suspend(true);
        this.audioCapture.suspend(true);
        this.mp3Stream.suspend(true);
        this.timeDelay(250);
        this.arraySize = this.getInt(this.sv_arraySizeComboBoxIndex, this.arraySize);
        if (sampleRateEntry) {
            this.sampleRate = this.getDouble(this.sv_sampleRateTextField, this.sampleRate);
        } else {
            this.setSampleRate();
        }
        this.sv_sampleRateTextField.setText(this.formatNum(this.sampleRate));
        this.adjustControls();
        this.signalProcessor.initialize(true);
        this.audioCapture.suspend(false);
        this.mp3Stream.suspend(false);
        this.signalProcessor.suspend(false);
    }

    public void adjustControls() {
        this.carrier = this.getDouble(this.sv_carrierTextField, this.carrier);
        this.modFreq = this.getDouble(this.sv_modFreqTextField, this.modFreq);
        this.modLevel = this.getDouble(this.sv_modPercentTextField, this.modLevel * 100.0) * 0.01;
        this.noiseLevel = this.getDouble(this.sv_noiseLevelTextField, this.noiseLevel * 100.0) * 0.01;
        this.freqControl.adjustControls();
        this.timeControl.adjustControls();
        this.graphicLineWidth = this.getInt(this.sv_lineWidthComboBox, this.graphicLineWidth);
        this.setSampleRate();
    }

    public void readControls() {
        this.readControls(false);
    }

    public void setSampleRate() {
        this.sampleRate = this.audioCapture.capturing() ? this.audioCapture.getSampleRate() : (this.streamMP3() ? (double)this.mp3Stream.sampleRate() : (double)this.signalProcessor.getSampleRate());
        this.sv_sampleRateTextField.setText(this.formatNum(this.sampleRate));
        this.freqControl.setup(false);
        this.timeControl.setup(false);
    }

    void timeDelay(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    double getDouble(String s) {
        double v = 0.0;
        try {
            s = s.toLowerCase();
            String[] array = s.split("e");
            v = this.numberFormat.parse(array[0]).doubleValue();
            if (array.length > 1) {
                double e2 = this.numberFormat.parse(array[1]).doubleValue();
                v *= Math.pow(10.0, e2);
            }
        }
        catch (Exception ex) {
            System.out.println(this.getClass().getName() + ".getDouble: Error: " + ex);
        }
        return v;
    }

    double getDouble(JTextField tf, double v) {
        try {
            v = this.getDouble(tf.getText());
        }
        catch (Exception e2) {
            System.out.println(this.getClass().getName() + ": Error: " + e2);
        }
        return v;
    }

    int getInt(JTextField tf, int v) {
        try {
            v = Integer.parseInt(tf.getText());
        }
        catch (Exception e2) {
            System.out.println(this.getClass().getName() + ": Error: " + e2);
        }
        return v;
    }

    double getDouble(JComboBox box, double v) {
        try {
            String s = (String)box.getSelectedItem();
            v = this.getDouble(s);
        }
        catch (Exception e2) {
            System.out.println(this.getClass().getName() + ": Error: " + e2);
        }
        return v;
    }

    int getInt(JComboBox box, int v) {
        try {
            String s = (String)box.getSelectedItem();
            v = Integer.parseInt(s);
        }
        catch (Exception e2) {
            System.out.println(this.getClass().getName() + ": Error: " + e2);
        }
        return v;
    }

    protected String getEngFormatString(double v, boolean freq) {
        String ss;
        if (freq) {
            int j2 = -1;
            while (++j2 < 4 && v >= 1000.0) {
                v /= 1000.0;
            }
            ss = this.freqUnits[j2];
        } else {
            int j3 = -1;
            while (++j3 < 4 && v < 1.0) {
                v *= 1000.0;
            }
            if (j3 >= 4) {
                j3 = 0;
            }
            ss = this.timeUnits[j3];
        }
        return this.formatNum(v) + " " + ss;
    }

    public double ntrp(double x, double xa, double xb, double ya, double yb) {
        return (x - xa) / (xb - xa) * (yb - ya) + ya;
    }

    public String formatNum(Double v) {
        String fmt = Math.abs(v) < 0.001 ? "%.3g" : "%.3f";
        return String.format(fmt, v);
    }

    void audioCapture(boolean start) {
        if (start) {
            if (this.applet) {
                this.appletError();
            } else {
                this.signalProcessor.synthDisplay(false);
                this.streamMP3(false);
                this.setSampleRate();
                this.audioCapture.startCapture();
            }
        } else {
            this.audioCapture.stopCapture();
        }
        this.startAudioCaptureButton.setEnabled(!this.audioCapture.capturing());
        this.stopAudioCaptureButton.setEnabled(this.audioCapture.capturing());
    }

    void setAudioSampleColor(boolean success) {
        this.soundCardSourceLabel.setForeground(success ? Color.black : Color.red);
    }

    void setArraySizeLabelColor(boolean success) {
        this.arraySizeLabel.setForeground(success ? Color.black : Color.red);
    }

    void streamMP3(boolean start) {
        if (this.mp3Stream == null) {
            this.mp3Stream = new MP3Stream(this);
        }
        if (start) {
            if (this.applet) {
                this.appletError();
            } else {
                this.signalProcessor.synthDisplay(false);
                this.audioCapture(false);
                this.mp3Stream.streamMP3(this.arraySize);
            }
        } else {
            this.mp3Stream.stopStream();
        }
        this.streamMP3ButtonControl(start);
    }

    void streamMP3ButtonControl(boolean start) {
        this.mp3StreamProgressBar.setValue(0);
        this.mp3StreamProgressBar.setStringPainted(false);
        this.startMP3Button.setEnabled(!start);
        this.stopMP3Button.setEnabled(start);
    }

    boolean streamMP3() {
        return this.mp3Stream != null && this.mp3Stream.playing();
    }

    public boolean changeLookAndFeel(Component comp) {
        boolean changed = false;
        String laf = UIManager.getLookAndFeel().getDescription();
        if (laf != null && laf.matches("GTK.*")) {
            String lf = UIManager.getCrossPlatformLookAndFeelClassName();
            try {
                UIManager.setLookAndFeel(lf);
                SwingUtilities.updateComponentTreeUI(comp);
                changed = true;
            }
            catch (Exception e2) {
                System.out.println(e2);
            }
        }
        return changed;
    }

    public void restoreSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void handleTabbedPaneChange() {
        Component comp = this.sv_mainTabbedPane.getSelectedComponent();
        boolean isHelp = comp == this.helpPanel;
        this.graphicHolderPanel.setVisible(!isHelp);
        this.helpPanel.setVisible(isHelp);
        this.helpPane.setVisible(isHelp);
        if (isHelp) {
            this.helpPane.sv_findTextField.requestFocus();
        }
        this.validate();
    }

    void resetDefaults(boolean activate) {
        this.signalProcessor.synthDisplay(false);
        this.streamMP3(false);
        this.audioCapture(false);
        this.sv_arraySizeComboBoxIndex.setSelectedItem("8192");
        this.sv_audioDataRateComboBoxIndex.setSelectedItem("192000");
        this.sv_graphicTipFlag = true;
        this.sv_carrierTextField.setText(this.formatNum(256.02));
        this.sv_modFreqTextField.setText("12");
        this.sv_modPercentTextField.setText(this.formatNum(100.0));
        this.sv_noiseLevelTextField.setText(this.formatNum(20.0));
        this.sv_xTimeOffset = 0.0;
        this.sv_xFreqOffset = 0.0;
        this.freqControl.graphicPane.setupOffset();
        this.timeControl.graphicPane.setupOffset();
        this.sv_traceColor.setColor(new Color(0, 128, 0));
        this.sv_backgroundColor.setColor(new Color(255, 255, 255));
        this.sv_timeVertIndex.setSelectedItem(this.formatNum(0.2));
        this.sv_freqVertIndex.setSelectedItem(this.formatNum(1.0));
        this.sv_timeHorizIndex.setSelectedIndex(2);
        this.sv_freqHorizIndex.setSelectedIndex(3);
        this.sv_mainTabbedPane.setSelectedIndex(0);
        if (this.applet) {
            this.sv_soundCheckBox.setSelected(true);
        } else {
            this.sv_soundCheckBox.setSelected(false);
        }
        this.sv_horizontalCheckBox.setSelected(false);
        this.sv_antialiasCheckBox.setSelected(false);
        this.sv_lineWidthComboBox.setSelectedItem("2");
        this.sv_amRadioButton.setSelected(true);
        this.setupDisplayConfig();
        this.readControls();
        if (activate) {
            this.signalProcessor.synthDisplay(true);
        }
    }

    void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public String getConfig() {
        if (this.initManager != null) {
            return this.initManager.getConfig();
        }
        return null;
    }

    public void setConfig(String data) {
        this.initManager.setConfig(data);
        this.readControls();
        this.setupDisplayConfig();
        this.handleTabbedPaneChange();
        this.revalidate();
        this.repaint();
        this.signalProcessor.synthDisplay(true);
    }

    public void mouse_entered() {
        this.requestFocus();
    }

    public void close() {
        if (!this.applet) {
            this.initManager.writeConfig();
        }
        this.setVisible(false);
        System.exit(0);
    }

    private void initComponents() {
        this.synthModeButtonGroup = new ButtonGroup();
        this.graphicHolderPanel = new JPanel();
        this.gControlPanel = new JPanel();
        this.sv_timeDispCheckBox = new JCheckBox();
        this.sv_freqDispCheckBox = new JCheckBox();
        this.sv_horizontalCheckBox = new JCheckBox();
        this.sv_antialiasCheckBox = new JCheckBox();
        this.sv_lineWidthComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.gContentPanel = new JPanel();
        this.southPanel = new JPanel();
        this.sv_mainTabbedPane = new JTabbedPane();
        this.internalSourcePanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.sv_carrierTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.sv_modFreqTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.sv_modPercentTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.sv_noiseLevelTextField = new JTextField();
        this.modePanel = new JPanel();
        this.sv_amRadioButton = new JRadioButton();
        this.sv_sqwRadioButton = new JRadioButton();
        this.sv_fmRadioButton = new JRadioButton();
        this.sv_twRadioButton = new JRadioButton();
        this.sv_stRadioButton = new JRadioButton();
        this.sv_soundCheckBox = new JCheckBox();
        this.startSynthButton = new JButton();
        this.stopSynthButton = new JButton();
        this.soundCapturePanel = new JPanel();
        this.soundCardPanel = new JPanel();
        this.startAudioCaptureButton = new JButton();
        this.stopAudioCaptureButton = new JButton();
        this.soundCardSourceLabel = new JLabel();
        this.sv_audioDataRateComboBoxIndex = new JComboBox();
        this.audioDataRateLabel = new JLabel();
        this.mp3Panel = new JPanel();
        this.startMP3Button = new JButton();
        this.mp3StreamProgressBar = new JProgressBar();
        this.jLabel11 = new JLabel();
        this.stopMP3Button = new JButton();
        this.configPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.sv_sampleRateTextField = new JTextField();
        this.arraySizeLabel = new JLabel();
        this.sv_arraySizeComboBoxIndex = new JComboBox();
        this.configSubPanel = new JPanel();
        this.jLabel7 = new JLabel();
        this.traceColorButton = new JButton();
        this.jLabel8 = new JLabel();
        this.backgroundColorButton = new JButton();
        this.defaultsButton = new JButton();
        this.helpPanel = new JPanel();
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                FFTExplorer.this.formMouseEntered(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        this.graphicHolderPanel.setLayout(new GridBagLayout());
        this.gControlPanel.setBackground(new Color(213, 242, 254));
        this.gControlPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.gControlPanel.setLayout(new GridBagLayout());
        this.sv_timeDispCheckBox.setBackground(new Color(213, 242, 254));
        this.sv_timeDispCheckBox.setSelected(true);
        this.sv_timeDispCheckBox.setText("Time");
        this.sv_timeDispCheckBox.setToolTipText("Show time scope");
        this.sv_timeDispCheckBox.setHorizontalAlignment(0);
        this.sv_timeDispCheckBox.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FFTExplorer.this.sv_timeDispCheckBoxMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gControlPanel.add((Component)this.sv_timeDispCheckBox, gridBagConstraints);
        this.sv_freqDispCheckBox.setBackground(new Color(213, 242, 254));
        this.sv_freqDispCheckBox.setSelected(true);
        this.sv_freqDispCheckBox.setText("Frequency");
        this.sv_freqDispCheckBox.setToolTipText("Show frequency scope");
        this.sv_freqDispCheckBox.setHorizontalAlignment(0);
        this.sv_freqDispCheckBox.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FFTExplorer.this.sv_freqDispCheckBoxMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gControlPanel.add((Component)this.sv_freqDispCheckBox, gridBagConstraints);
        this.sv_horizontalCheckBox.setBackground(new Color(213, 242, 254));
        this.sv_horizontalCheckBox.setText("Horizontal");
        this.sv_horizontalCheckBox.setToolTipText("Arrange scopes horizontally");
        this.sv_horizontalCheckBox.setHorizontalAlignment(0);
        this.sv_horizontalCheckBox.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FFTExplorer.this.sv_horizontalCheckBoxMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gControlPanel.add((Component)this.sv_horizontalCheckBox, gridBagConstraints);
        this.sv_antialiasCheckBox.setBackground(new Color(213, 242, 254));
        this.sv_antialiasCheckBox.setText("Antialias");
        this.sv_antialiasCheckBox.setToolTipText("Better-looking, but slower drawing");
        this.sv_antialiasCheckBox.setHorizontalAlignment(0);
        this.sv_antialiasCheckBox.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FFTExplorer.this.sv_antialiasCheckBoxMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gControlPanel.add((Component)this.sv_antialiasCheckBox, gridBagConstraints);
        this.sv_lineWidthComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_lineWidthComboBox.setToolTipText("Slows drawing down");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gControlPanel.add((Component)this.sv_lineWidthComboBox, gridBagConstraints);
        this.jLabel2.setText("Line Width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.gControlPanel.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.graphicHolderPanel.add((Component)this.gControlPanel, gridBagConstraints);
        this.gContentPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.graphicHolderPanel.add((Component)this.gContentPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 10.0;
        this.add((Component)this.graphicHolderPanel, gridBagConstraints);
        this.southPanel.setLayout(new GridBagLayout());
        this.sv_mainTabbedPane.setTabLayoutPolicy(1);
        this.sv_mainTabbedPane.setTabPlacement(3);
        this.sv_mainTabbedPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FFTExplorer.this.sv_mainTabbedPaneMouseClicked(evt);
            }
        });
        this.internalSourcePanel.setBackground(new Color(254, 254, 205));
        this.internalSourcePanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.internalSourcePanel.setLayout(new GridBagLayout());
        this.jLabel3.setText("Carrier Freq. Hz");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.internalSourcePanel.add((Component)this.jLabel3, gridBagConstraints);
        this.sv_carrierTextField.setHorizontalAlignment(4);
        this.sv_carrierTextField.setText("100.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.internalSourcePanel.add((Component)this.sv_carrierTextField, gridBagConstraints);
        this.jLabel4.setText("Mod. Freq. Hz");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.internalSourcePanel.add((Component)this.jLabel4, gridBagConstraints);
        this.sv_modFreqTextField.setHorizontalAlignment(4);
        this.sv_modFreqTextField.setText("25.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.internalSourcePanel.add((Component)this.sv_modFreqTextField, gridBagConstraints);
        this.jLabel5.setText("Mod. Level %");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.internalSourcePanel.add((Component)this.jLabel5, gridBagConstraints);
        this.sv_modPercentTextField.setHorizontalAlignment(4);
        this.sv_modPercentTextField.setText("100.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.internalSourcePanel.add((Component)this.sv_modPercentTextField, gridBagConstraints);
        this.jLabel6.setText("Noise Level %");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.internalSourcePanel.add((Component)this.jLabel6, gridBagConstraints);
        this.sv_noiseLevelTextField.setHorizontalAlignment(4);
        this.sv_noiseLevelTextField.setText("100.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.internalSourcePanel.add((Component)this.sv_noiseLevelTextField, gridBagConstraints);
        this.modePanel.setBackground(new Color(254, 254, 205));
        this.modePanel.setLayout(new GridBagLayout());
        this.sv_amRadioButton.setBackground(new Color(254, 254, 205));
        this.synthModeButtonGroup.add(this.sv_amRadioButton);
        this.sv_amRadioButton.setSelected(true);
        this.sv_amRadioButton.setText("AM");
        this.sv_amRadioButton.setToolTipText("Amplitude-modulation waveform");
        this.sv_amRadioButton.setAlignmentX(0.5f);
        this.sv_amRadioButton.setHorizontalAlignment(0);
        this.sv_amRadioButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FFTExplorer.this.sv_amRadioButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.modePanel.add((Component)this.sv_amRadioButton, gridBagConstraints);
        this.sv_sqwRadioButton.setBackground(new Color(254, 254, 205));
        this.synthModeButtonGroup.add(this.sv_sqwRadioButton);
        this.sv_sqwRadioButton.setText("Square");
        this.sv_sqwRadioButton.setToolTipText("Square wave");
        this.sv_sqwRadioButton.setAlignmentX(0.5f);
        this.sv_sqwRadioButton.setHorizontalAlignment(0);
        this.sv_sqwRadioButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FFTExplorer.this.sv_sqwRadioButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.modePanel.add((Component)this.sv_sqwRadioButton, gridBagConstraints);
        this.sv_fmRadioButton.setBackground(new Color(254, 254, 205));
        this.synthModeButtonGroup.add(this.sv_fmRadioButton);
        this.sv_fmRadioButton.setText("FM");
        this.sv_fmRadioButton.setToolTipText("Frequency-modulation waveform");
        this.sv_fmRadioButton.setAlignmentX(0.5f);
        this.sv_fmRadioButton.setHorizontalAlignment(0);
        this.sv_fmRadioButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FFTExplorer.this.sv_fmRadioButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.modePanel.add((Component)this.sv_fmRadioButton, gridBagConstraints);
        this.sv_twRadioButton.setBackground(new Color(254, 254, 205));
        this.synthModeButtonGroup.add(this.sv_twRadioButton);
        this.sv_twRadioButton.setText("Triangle");
        this.sv_twRadioButton.setToolTipText("Triangle wave");
        this.sv_twRadioButton.setAlignmentX(0.5f);
        this.sv_twRadioButton.setHorizontalAlignment(0);
        this.sv_twRadioButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FFTExplorer.this.sv_twRadioButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.modePanel.add((Component)this.sv_twRadioButton, gridBagConstraints);
        this.sv_stRadioButton.setBackground(new Color(254, 254, 205));
        this.synthModeButtonGroup.add(this.sv_stRadioButton);
        this.sv_stRadioButton.setText("Sawtooth");
        this.sv_stRadioButton.setToolTipText("Sawtooth wave");
        this.sv_stRadioButton.setAlignmentX(0.5f);
        this.sv_stRadioButton.setHorizontalAlignment(0);
        this.sv_stRadioButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FFTExplorer.this.sv_stRadioButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.modePanel.add((Component)this.sv_stRadioButton, gridBagConstraints);
        this.sv_soundCheckBox.setBackground(new Color(254, 254, 205));
        this.sv_soundCheckBox.setSelected(true);
        this.sv_soundCheckBox.setText("Sound");
        this.sv_soundCheckBox.setToolTipText("<html>Create sound of synthesized waveform<br/>(limits program to 1 frame/sec)");
        this.sv_soundCheckBox.setAlignmentX(0.5f);
        this.sv_soundCheckBox.setHorizontalAlignment(0);
        this.sv_soundCheckBox.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FFTExplorer.this.sv_soundCheckBoxMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.modePanel.add((Component)this.sv_soundCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.internalSourcePanel.add((Component)this.modePanel, gridBagConstraints);
        this.startSynthButton.setText("Start");
        this.startSynthButton.setToolTipText("Press to start the synthesizer");
        this.startSynthButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FFTExplorer.this.startSynthButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.internalSourcePanel.add((Component)this.startSynthButton, gridBagConstraints);
        this.stopSynthButton.setText("Stop");
        this.stopSynthButton.setToolTipText("Press to stop the synthesizer");
        this.stopSynthButton.setEnabled(false);
        this.stopSynthButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FFTExplorer.this.stopSynthButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.internalSourcePanel.add((Component)this.stopSynthButton, gridBagConstraints);
        this.sv_mainTabbedPane.addTab("Synthesizer", new ImageIcon(this.getClass().getResource("/fftexplorer/icons/applications-multimedia.png")), this.internalSourcePanel);
        this.soundCapturePanel.setLayout(new GridBagLayout());
        this.soundCardPanel.setBackground(new Color(223, 255, 221));
        this.soundCardPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.soundCardPanel.setLayout(new GridBagLayout());
        this.startAudioCaptureButton.setText("Start");
        this.startAudioCaptureButton.setToolTipText("Start sound card capture");
        this.startAudioCaptureButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FFTExplorer.this.startAudioCaptureButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.soundCardPanel.add((Component)this.startAudioCaptureButton, gridBagConstraints);
        this.stopAudioCaptureButton.setText("Stop");
        this.stopAudioCaptureButton.setEnabled(false);
        this.stopAudioCaptureButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FFTExplorer.this.stopAudioCaptureButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.soundCardPanel.add((Component)this.stopAudioCaptureButton, gridBagConstraints);
        this.soundCardSourceLabel.setFont(new Font("DejaVu Sans", 1, 14));
        this.soundCardSourceLabel.setHorizontalAlignment(0);
        this.soundCardSourceLabel.setIcon(new ImageIcon(this.getClass().getResource("/fftexplorer/icons/audio-card.png")));
        this.soundCardSourceLabel.setText("Sound Card Source");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.soundCardPanel.add((Component)this.soundCardSourceLabel, gridBagConstraints);
        this.sv_audioDataRateComboBoxIndex.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_audioDataRateComboBoxIndex.setToolTipText("Highest data rate is preferred");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.soundCardPanel.add((Component)this.sv_audioDataRateComboBoxIndex, gridBagConstraints);
        this.audioDataRateLabel.setText("Data Rate:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.soundCardPanel.add((Component)this.audioDataRateLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.soundCapturePanel.add((Component)this.soundCardPanel, gridBagConstraints);
        this.mp3Panel.setBackground(new Color(205, 223, 255));
        this.mp3Panel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.mp3Panel.setLayout(new GridBagLayout());
        this.startMP3Button.setText("Start");
        this.startMP3Button.setToolTipText("Choose a sound file and play it");
        this.startMP3Button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FFTExplorer.this.startMP3ButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mp3Panel.add((Component)this.startMP3Button, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.mp3Panel.add((Component)this.mp3StreamProgressBar, gridBagConstraints);
        this.jLabel11.setFont(new Font("DejaVu Sans", 1, 14));
        this.jLabel11.setHorizontalAlignment(0);
        this.jLabel11.setIcon(new ImageIcon(this.getClass().getResource("/fftexplorer/icons/audio-x-monkey.png")));
        this.jLabel11.setText("Audio File Source");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mp3Panel.add((Component)this.jLabel11, gridBagConstraints);
        this.stopMP3Button.setText("Stop");
        this.stopMP3Button.setEnabled(false);
        this.stopMP3Button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FFTExplorer.this.stopMP3ButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mp3Panel.add((Component)this.stopMP3Button, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.01;
        this.soundCapturePanel.add((Component)this.mp3Panel, gridBagConstraints);
        this.sv_mainTabbedPane.addTab("External Sources", new ImageIcon(this.getClass().getResource("/fftexplorer/icons/audio-input-microphone.png")), this.soundCapturePanel);
        this.configPanel.setBackground(new Color(234, 235, 254));
        this.configPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.configPanel.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 14));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Sample Rate:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.configPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.sv_sampleRateTextField.setHorizontalAlignment(4);
        this.sv_sampleRateTextField.setText("8192.0");
        this.sv_sampleRateTextField.setToolTipText("See help for setting this field");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.configPanel.add((Component)this.sv_sampleRateTextField, gridBagConstraints);
        this.arraySizeLabel.setFont(new Font("DejaVu Sans", 1, 14));
        this.arraySizeLabel.setHorizontalAlignment(0);
        this.arraySizeLabel.setText("FFT Array Size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 4);
        this.configPanel.add((Component)this.arraySizeLabel, gridBagConstraints);
        this.sv_arraySizeComboBoxIndex.setBackground(new Color(234, 235, 254));
        this.sv_arraySizeComboBoxIndex.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_arraySizeComboBoxIndex.setToolTipText("Large values give more detail but take longer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.configPanel.add((Component)this.sv_arraySizeComboBoxIndex, gridBagConstraints);
        this.configSubPanel.setBackground(new Color(234, 235, 254));
        this.configSubPanel.setLayout(new GridBagLayout());
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setText("Line color:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.configSubPanel.add((Component)this.jLabel7, gridBagConstraints);
        this.traceColorButton.setText("jButton1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.configSubPanel.add((Component)this.traceColorButton, gridBagConstraints);
        this.jLabel8.setHorizontalAlignment(0);
        this.jLabel8.setText("Background color:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.configSubPanel.add((Component)this.jLabel8, gridBagConstraints);
        this.backgroundColorButton.setText("jButton1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.configSubPanel.add((Component)this.backgroundColorButton, gridBagConstraints);
        this.defaultsButton.setText("Reset All Defaults");
        this.defaultsButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FFTExplorer.this.defaultsButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.configSubPanel.add((Component)this.defaultsButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.configPanel.add((Component)this.configSubPanel, gridBagConstraints);
        this.sv_mainTabbedPane.addTab("Configure", new ImageIcon(this.getClass().getResource("/fftexplorer/icons/applications-accessories.png")), this.configPanel);
        this.helpPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.helpPanel.setLayout(new GridBagLayout());
        this.sv_mainTabbedPane.addTab("Help", new ImageIcon(this.getClass().getResource("/fftexplorer/icons/system-help.png")), this.helpPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.001;
        this.southPanel.add((Component)this.sv_mainTabbedPane, gridBagConstraints);
        this.statusPanel.setLayout(new GridBagLayout());
        this.statusLabel.setText("Status/Position");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.statusPanel.add((Component)this.statusLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.southPanel.add((Component)this.statusPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.01;
        this.add((Component)this.southPanel, gridBagConstraints);
    }

    private void sv_timeDispCheckBoxMouseClicked(MouseEvent evt) {
        this.setupDisplayConfig();
    }

    private void sv_freqDispCheckBoxMouseClicked(MouseEvent evt) {
        this.setupDisplayConfig();
    }

    private void sv_horizontalCheckBoxMouseClicked(MouseEvent evt) {
        this.setupDisplayConfig();
    }

    private void sv_antialiasCheckBoxMouseClicked(MouseEvent evt) {
        this.adjustControls();
    }

    private void sv_amRadioButtonMouseClicked(MouseEvent evt) {
        this.signalProcessor.setMode();
    }

    private void sv_sqwRadioButtonMouseClicked(MouseEvent evt) {
        this.signalProcessor.setMode();
    }

    private void sv_fmRadioButtonMouseClicked(MouseEvent evt) {
        this.signalProcessor.setMode();
    }

    private void sv_twRadioButtonMouseClicked(MouseEvent evt) {
        this.signalProcessor.setMode();
    }

    private void sv_stRadioButtonMouseClicked(MouseEvent evt) {
        this.readControls();
    }

    private void sv_soundCheckBoxMouseClicked(MouseEvent evt) {
        this.readControls();
    }

    private void startSynthButtonMouseClicked(MouseEvent evt) {
        this.signalProcessor.synthDisplay(true);
    }

    private void stopSynthButtonMouseClicked(MouseEvent evt) {
        this.signalProcessor.synthDisplay(false);
    }

    private void startAudioCaptureButtonMouseClicked(MouseEvent evt) {
        this.audioCapture(true);
    }

    private void stopAudioCaptureButtonMouseClicked(MouseEvent evt) {
        this.audioCapture(false);
    }

    private void startMP3ButtonMouseClicked(MouseEvent evt) {
        this.streamMP3(true);
    }

    private void stopMP3ButtonMouseClicked(MouseEvent evt) {
        this.streamMP3(false);
    }

    private void defaultsButtonMouseClicked(MouseEvent evt) {
        this.resetDefaults(this.applet);
    }

    private void sv_mainTabbedPaneMouseClicked(MouseEvent evt) {
        this.handleTabbedPaneChange();
    }

    private void formMouseEntered(MouseEvent evt) {
        this.mouse_entered();
    }
}

