/*
 * Decompiled with CFR 0.152.
 */
package fftexplorer;

import fftexplorer.ComboControl;
import fftexplorer.Complex;
import fftexplorer.FFTExplorer;
import fftexplorer.GraphicPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseWheelEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GraphicControl
extends JPanel {
    boolean freq;
    FFTExplorer parent;
    GraphicPanel graphicPane;
    Vector<Double> hVals;
    double timeSpan = 1.0;
    double freqSpan = 1.0;
    private JPanel cPanel;
    protected JComboBox horizComboBox;
    private JLabel idLabel;
    private JLabel jLabel1;
    private JPanel targetPanel;
    protected JComboBox vertComboBox;

    public GraphicControl(FFTExplorer p, boolean freq) {
        this.parent = p;
        this.initComponents();
        this.freq = freq;
        this.idLabel.setText(freq ? "Frequency span:" : "Time span:");
        this.graphicPane = new GraphicPanel(this.parent, this, freq);
        this.targetPanel.add((Component)this.graphicPane, "Center");
        new ComboControl(this, this.vertComboBox);
        new ComboControl(this, this.horizComboBox);
        this.setup(true);
    }

    public void setup(boolean first) {
        double w;
        double v;
        this.setupScale();
        this.hVals = new Vector();
        double[] steps = new double[]{1.0, 2.0, 4.0, 8.0};
        int vn = this.vertComboBox.getSelectedIndex();
        int hn = this.horizComboBox.getSelectedIndex();
        this.vertComboBox.removeAllItems();
        for (int n2 = -6; n2 <= 6; ++n2) {
            v = Math.pow(10.0, n2);
            for (int i2 = 0; i2 < steps.length; ++i2) {
                w = v * steps[i2];
                this.vertComboBox.addItem(this.parent.formatNum(w));
            }
        }
        double q = this.freq ? this.freqSpan : this.timeSpan;
        this.horizComboBox.removeAllItems();
        for (int n3 = 0; n3 <= 6; ++n3) {
            v = Math.pow(10.0, n3);
            for (int i3 = 0; i3 < steps.length; ++i3) {
                w = v * steps[i3];
                this.horizComboBox.addItem(this.parent.getEngFormatString(q / w, this.freq));
                this.hVals.add(1.0 / w);
            }
        }
        vn = first ? 0 : vn;
        hn = first ? 0 : hn;
        this.vertComboBox.setSelectedIndex(vn);
        this.horizComboBox.setSelectedIndex(hn);
        this.adjustControls();
    }

    public void setupScale() {
        this.timeSpan = (double)this.parent.arraySize / this.parent.sampleRate;
        this.freqSpan = this.parent.sampleRate / 2.0;
    }

    void setData(Complex[] data) {
        this.graphicPane.setData(data);
    }

    public void adjustControls() {
        this.graphicPane.vScale = this.getDouble(this.vertComboBox, this.graphicPane.vScale);
        this.graphicPane.antialias = this.parent.sv_antialiasCheckBox.isSelected();
        this.graphicPane.hScale = this.getDouble(this.horizComboBox, this.graphicPane.hScale);
        this.graphicPane.adjustOffset();
    }

    double getDouble(JComboBox box, double v) {
        if (box == this.horizComboBox) {
            int n2 = box.getSelectedIndex();
            v = this.hVals.get(n2);
        } else {
            String s = (String)box.getSelectedItem();
            try {
                v = this.parent.numberFormat.parse(s).doubleValue();
            }
            catch (Exception e2) {
                System.out.println("getDouble: " + e2);
            }
        }
        return v;
    }

    void handleWheelEvent(MouseWheelEvent evt) {
        double n2 = -evt.getWheelRotation();
        int v = this.horizComboBox.getSelectedIndex();
        v = (int)((double)v + n2);
        int top = this.horizComboBox.getItemCount();
        v = v < 0 ? 0 : v;
        v = v >= top ? top - 1 : v;
        this.horizComboBox.setSelectedIndex(v);
        this.adjustControls();
    }

    private void initComponents() {
        this.cPanel = new JPanel();
        this.idLabel = new JLabel();
        this.horizComboBox = new JComboBox();
        this.vertComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.targetPanel = new JPanel();
        this.setBorder(null);
        this.setLayout(new GridBagLayout());
        this.cPanel.setBackground(new Color(254, 240, 230));
        this.cPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.cPanel.setLayout(new GridBagLayout());
        this.idLabel.setText("...");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.cPanel.add((Component)this.idLabel, gridBagConstraints);
        this.horizComboBox.setBackground(new Color(254, 240, 230));
        this.horizComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.cPanel.add((Component)this.horizComboBox, gridBagConstraints);
        this.vertComboBox.setBackground(new Color(254, 240, 230));
        this.vertComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.cPanel.add((Component)this.vertComboBox, gridBagConstraints);
        this.jLabel1.setText("Vertical Gain:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.cPanel.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.cPanel, gridBagConstraints);
        this.targetPanel.setBorder(null);
        this.targetPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 10.0;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        this.add((Component)this.targetPanel, gridBagConstraints);
    }
}

