/*
 * Decompiled with CFR 0.152.
 */
package fftexplorer;

import fftexplorer.FFTExplorer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.html.HTMLDocument;

public final class MyHelpPane
extends JPanel {
    FFTExplorer parent;
    Stack<Integer> undoStack;
    Stack<Integer> redoStack;
    Document doc = null;
    String oldSearch = "";
    int oldPos = 0;
    Object oldHighlight = null;
    Highlighter highlighter;
    Highlighter.HighlightPainter highlightPainter;
    String help_file_path = "help_resources/HelpText.html";
    private JScrollPane helpScrollPane;
    private JTextPane helpTextPane;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JButton redoButton;
    protected JTextField sv_findTextField;
    private JButton undoButton;

    public MyHelpPane(FFTExplorer p) {
        this.parent = p;
        this.initComponents();
        this.parent.sv_helpScrollBar = this.helpScrollPane.getVerticalScrollBar();
        this.doc = this.helpTextPane.getDocument();
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.highlighter = this.helpTextPane.getHighlighter();
        this.highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(200, 255, 200));
        this.setupHelp();
        this.setButtons();
    }

    void setupHelp() {
        try {
            String line;
            InputStream is = this.parent.getClass().getResourceAsStream(this.help_file_path);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            is.close();
            String content = sb.toString();
            content = content.replaceAll("#version#", this.parent.appVersion);
            content = !this.parent.applet ? content.replaceAll("#userdir#", this.parent.initManager.userPath) : content.replaceAll("#userdir#", "(user directory)");
            URL url = this.parent.getClass().getResource(this.help_file_path).toURI().toURL();
            ((HTMLDocument)this.helpTextPane.getDocument()).setBase(url);
            this.helpTextPane.setText(content);
        }
        catch (Exception e2) {
            System.out.println("setupHelp: " + e2);
            e2.printStackTrace();
        }
    }

    void manageHyperlinks(HyperlinkEvent evt) {
        URL url = evt.getURL();
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String surl = evt.getURL().toString();
            if (surl.matches("http://.*")) {
                try {
                    Desktop.getDesktop().browse(URI.create(surl));
                }
                catch (Exception e2) {
                    System.out.println(e2);
                }
            } else if (surl.matches(".*#.*")) {
                try {
                    this.pushUndo();
                    this.helpTextPane.scrollToReference(url.getRef());
                }
                catch (Exception e3) {
                    System.out.println(e3);
                }
            }
        }
    }

    void undo() {
        if (this.undoStack.size() > 0) {
            this.removeOldHighlight();
            this.pushRedo();
            this.helpScrollPane.getVerticalScrollBar().setValue(this.undoStack.pop());
            this.setButtons();
        } else {
            this.parent.beep();
        }
    }

    void redo() {
        if (this.redoStack.size() > 0) {
            this.removeOldHighlight();
            this.pushUndo();
            this.helpScrollPane.getVerticalScrollBar().setValue(this.redoStack.pop());
            this.setButtons();
        } else {
            this.parent.beep();
        }
    }

    void pushUndo() {
        this.undoStack.push(this.helpScrollPane.getVerticalScrollBar().getValue());
        this.setButtons();
    }

    void pushRedo() {
        this.redoStack.push(this.helpScrollPane.getVerticalScrollBar().getValue());
        this.setButtons();
    }

    void setButtons() {
        this.undoButton.setEnabled(this.undoStack.size() > 0);
        this.redoButton.setEnabled(this.redoStack.size() > 0);
    }

    void removeOldHighlight() {
        if (this.oldHighlight != null) {
            this.highlighter.removeHighlight(this.oldHighlight);
            this.oldHighlight = null;
        }
    }

    void manageHelpTextField(KeyEvent evt) {
        try {
            this.removeOldHighlight();
            this.doc = this.helpTextPane.getDocument();
            int len = this.doc.getLength();
            String content = this.doc.getText(0, len).toLowerCase();
            String search = this.sv_findTextField.getText().toLowerCase();
            if (!search.equals(this.oldSearch)) {
                this.oldPos = 0;
            }
            this.oldSearch = search;
            int p = content.indexOf(search, this.oldPos);
            if (p == -1) {
                this.oldPos = 0;
                p = content.indexOf(search, this.oldPos);
            }
            if (p >= 0) {
                this.pushUndo();
                int slen = search.length();
                Rectangle r = this.helpTextPane.modelToView(p);
                int pos = r.y - this.helpScrollPane.getHeight() / 2;
                pos = pos < 0 ? 0 : pos;
                this.helpScrollPane.getVerticalScrollBar().setValue(pos);
                this.oldHighlight = this.highlighter.addHighlight(p, p + slen, this.highlightPainter);
                this.oldPos = p + 1;
            } else {
                this.parent.beep();
            }
        }
        catch (Exception e2) {
            System.out.println(e2);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.undoButton = new JButton();
        this.redoButton = new JButton();
        this.jLabel1 = new JLabel();
        this.sv_findTextField = new JTextField();
        this.helpScrollPane = new JScrollPane();
        this.helpTextPane = new JTextPane();
        this.setLayout(new GridBagLayout());
        this.undoButton.setIcon(new ImageIcon(this.getClass().getResource("/fftexplorer/icons/edit-undo.png")));
        this.undoButton.setToolTipText("Go back");
        this.undoButton.setFocusable(false);
        this.undoButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MyHelpPane.this.undoButtonMouseClicked(evt);
            }
        });
        this.jPanel1.add(this.undoButton);
        this.redoButton.setIcon(new ImageIcon(this.getClass().getResource("/fftexplorer/icons/edit-redo.png")));
        this.redoButton.setToolTipText("Go forward");
        this.redoButton.setFocusable(false);
        this.redoButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MyHelpPane.this.redoButtonMouseClicked(evt);
            }
        });
        this.jPanel1.add(this.redoButton);
        this.jLabel1.setText("Search:");
        this.jPanel1.add(this.jLabel1);
        this.sv_findTextField.setToolTipText("<html>Quick search: type a search string,<br/>press Enter to find the next case</html>");
        this.sv_findTextField.setFocusCycleRoot(true);
        this.sv_findTextField.setMinimumSize(new Dimension(150, 27));
        this.sv_findTextField.setPreferredSize(new Dimension(150, 27));
        this.sv_findTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                MyHelpPane.this.sv_findTextFieldKeyReleased(evt);
            }
        });
        this.jPanel1.add(this.sv_findTextField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.helpScrollPane.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.helpTextPane.setContentType("text/html");
        this.helpTextPane.setEditable(false);
        this.helpTextPane.setFocusable(false);
        this.helpTextPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                MyHelpPane.this.helpTextPaneHyperlinkUpdate(evt);
            }
        });
        this.helpScrollPane.setViewportView(this.helpTextPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.helpScrollPane, gridBagConstraints);
    }

    private void undoButtonMouseClicked(MouseEvent evt) {
        this.undo();
    }

    private void redoButtonMouseClicked(MouseEvent evt) {
        this.redo();
    }

    private void sv_findTextFieldKeyReleased(KeyEvent evt) {
        this.manageHelpTextField(evt);
    }

    private void helpTextPaneHyperlinkUpdate(HyperlinkEvent evt) {
        this.manageHyperlinks(evt);
    }
}

