/*
 * Decompiled with CFR 0.152.
 */
package fftexplorer;

import fftexplorer.FFTExplorer;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public final class UserActionManager {
    JTextField field = null;
    JComboBox box = null;
    FFTExplorer parent;
    double sens = 1.0;
    double dmin;
    double dmax;
    int imin;
    int imax;
    String tip1 = "Spin mouse wheel to change";
    String tip2 = " (spin mouse wheel to change)";

    public UserActionManager(double sens, double min, double max, JTextField field, FFTExplorer p) {
        this.field = field;
        this.dmin = min;
        this.dmax = max;
        this.init(sens, p, field);
        this.assignHandlers(field);
    }

    public UserActionManager(JComboBox box, FFTExplorer p) {
        this.box = box;
        this.init(1.0, p, box);
        this.assignHandlers(box);
    }

    void init(double sens, FFTExplorer p, JComponent comp) {
        this.parent = p;
        this.sens = sens;
        this.setTip(comp);
    }

    void setTip(JComponent comp) {
        String tip = comp.getToolTipText();
        tip = tip == null || tip.length() == 0 ? this.tip1 : tip + this.tip2;
        comp.setToolTipText(tip);
    }

    public void assignHandlers(Component comp) {
        comp.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent evt) {
                UserActionManager.this.handleMouseWheelMoved(evt);
            }
        });
        comp.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                UserActionManager.this.handleKeyReleased(evt);
            }
        });
    }

    private void handleKeyReleased(KeyEvent evt) {
        int n2 = 0;
        double sign = 0.0;
        double v = this.sens;
        v = evt.isShiftDown() ? v * 10.0 : v;
        v = evt.isAltDown() ? v * 100.0 : v;
        int kcode = evt.getKeyCode();
        if (kcode == 10) {
            sign = 1.0;
        } else if (kcode == 36) {
            n2 = 100;
            sign = 1.0;
        } else if (kcode == 35) {
            n2 = -100;
            sign = 1.0;
        } else if (kcode == 33) {
            n2 = 10;
            sign = 1.0;
        } else if (kcode == 34) {
            n2 = -10;
            sign = 1.0;
        } else if (kcode == 40) {
            n2 = -1;
            sign = 1.0;
        } else if (kcode == 38) {
            n2 = 1;
            sign = 1.0;
        } else if (kcode == 27) {
            n2 = 0;
            sign = -1.0;
        }
        this.handleIncrement(n2, sign, v);
    }

    private void handleMouseWheelMoved(MouseWheelEvent evt) {
        double v = this.sens;
        v = evt.isShiftDown() ? v * 10.0 : v;
        v = evt.isAltDown() ? v * 100.0 : v;
        this.handleIncrement(-evt.getWheelRotation(), 1.0, v);
    }

    void handleIncrement(int n2, double sign, double sv) {
        if (sign != 0.0) {
            if (this.field != null) {
                String text = this.field.getText();
                double dv = 0.0;
                try {
                    dv = this.parent.getDouble(text);
                }
                catch (Exception e2) {
                    System.out.println(this.getClass().getName() + ": Error: " + e2);
                }
                dv += (double)n2 * sv;
                dv *= sign;
                dv = Math.min(this.dmax, dv);
                dv = Math.max(this.dmin, dv);
                String s = "" + this.parent.formatNum(dv);
                this.field.setText(s);
            } else if (this.box != null) {
                int v = this.box.getSelectedIndex();
                int top = this.box.getItemCount();
                v = (v += n2) < 0 ? 0 : v;
                v = v >= top ? top - 1 : v;
                this.box.setSelectedIndex(v);
            }
            if (this.parent != null) {
                if (this.field == this.parent.sv_noiseLevelTextField || this.field == this.parent.sv_carrierTextField || this.field == this.parent.sv_modPercentTextField || this.field == this.parent.sv_modFreqTextField || this.box == this.parent.sv_lineWidthComboBox) {
                    this.parent.adjustControls();
                } else {
                    this.parent.readControls(this.field == this.parent.sv_sampleRateTextField);
                }
            }
        }
    }
}

