/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "oscillatorfunctions.h"
#include <cmath>

OscillatorFunctions::OscillatorFunctions() {}


OscillatorFunctions::~OscillatorFunctions() {}

double OscillatorFunctions::sinewave(double f, double t) {

    return sin(2 * M_PI * f * t);
}

double OscillatorFunctions::trianglewave(double f, double t) {
    double q = ((fmod(t,(1.0 / f))) * 4 * f);
    q = (q < 1.0)?q:(q < 3.0)?2.0-q:q-4.0;
    return q;
}

double OscillatorFunctions::squarewave(double f, double t) {

    double q = fmod(t,1.0/f) * f;
    q = (q < .5)?1.0:-1.0;
    return q;
}

double OscillatorFunctions::sawtoothwave(double f, double t) {
    return ((fmod(t + (.5/f), 1.0 / f)) * 2 * f) - 1;
}

pfd OscillatorFunctions::fa[] = {sinewave,trianglewave,squarewave,sawtoothwave};

pfd OscillatorFunctions::getFunct(int i) {
    return fa[i];
}
