/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef OSCILLATORFUNCTIONS_H
#define OSCILLATORFUNCTIONS_H

typedef double (*pfd)(double,double);

/**
@author Paul Lutus
*/
class OscillatorFunctions {
public:
    OscillatorFunctions();

    ~OscillatorFunctions();

    static double sinewave(double f, double t);

    static double squarewave(double f, double t);

    static double trianglewave(double f, double t);

    static double sawtoothwave(double f, double t);

    static pfd fa[];
    
    static pfd getFunct(int i);

};

#endif
